(function() {
  //    FILE:EventListView
  //    PROJECT:fw-mobile
  //    Created by Rafa Dorado on 5/15/13
  //    Farmerswife SL.
  define(['jquery', 'underscore', 'Handlebars', 'Backbone', 'moment', 'mobiscroll', 'views/menu/MenuView', 'models/request/RequestModel', 'PrecompiledTemplates'], function($, _, Handlebars, Backbone, Moment, Mobiscroll, MenuView, RequestModel) {
    var MonthreportsListView;
    return MonthreportsListView = class MonthreportsListView extends Backbone.View {
      initialize(usr) {
        this.usr = usr;
        //console.log 'Month Reports'
        return this.reqMdl = new RequestModel();
      }

      attributes() {
        return {
          'data-role': 'page'
        };
      }

      events() {
        return {
          'tap #id-btn-panel': 'btnPanelClicked',
          'tap .report': 'reportClicked',
          'tap #id-btn-cancel-download': 'cancelDownloadClicked',
          //'tap #id-btn-download':'cancelDownloadClicked'
          'change #id-input-month': 'monthSelected'
        };
      }

      render() {
        var template;
        template = Handlebars.templates['MonthreportsListView'];
        this.$el.html(template({
          usr: this.usr.toJSON(),
          reports: this.__get_reports()
        }));
        this.addSidePanel();
        return this.$el;
      }

      addSidePanel() {
        if (!MenuView) {
          MenuView = require("views/menu/MenuView");
        }
        this.panel = new MenuView(this.usr);
        this.panel.render();
        return this.$el.append(this.panel.el);
      }

      reportClicked(event) {
        var btn;
        event.preventDefault();
        event.stopPropagation();
        btn = $(event.currentTarget);
        this.reportName = btn.attr('data-report');
        return this.__get_date_widget();
      }

      monthSelected(event) {
        var date, input, month, year;
        input = $(event.currentTarget);
        date = input.val();
        month = date.split('-')[1];
        year = date.split('-')[2];
        return this.__get_pdf_report(this.reportName, year, month);
      }

      cancelDownloadClicked(event) {
        event.preventDefault();
        event.stopPropagation();
        $('#divGeneratingReport').hide();
        $('.btn-generated').hide();
        $('#id-span-loading').show();
        return $('#divMonthReportsContent').show();
      }

      btnPanelClicked(event) {
        return this.panel.btnPanelClicked(event);
      }

      __get_date_widget() {
        var eventsBookableTimeFrameStart, eventsBookableTimeFrameStop, eventsViewableTimeFrameStart, eventsViewableTimeFrameStop, maxDate, minDate, options;
        options = {
          theme: 'iOS',
          display: 'bottom',
          dateFormat: 'dd-mm-yy',
          dateOrder: 'ddmmyy',
          maxDate: window.MAXDATE
        };
        if ((this.usr.get('eventsViewableTimeFrameStart') || this.usr.get('eventsBookableTimeFrameStart')) && (this.usr.get('eventsViewableTimeFrameStop') || this.usr.get('eventsBookableTimeFrameStop'))) {
          eventsViewableTimeFrameStart = Moment(this.usr.get('eventsViewableTimeFrameStart'), 'YYYY-MM-DD');
          eventsBookableTimeFrameStart = Moment(this.usr.get('eventsBookableTimeFrameStart'), 'YYYY-MM-DD');
          eventsViewableTimeFrameStop = Moment(this.usr.get('eventsViewableTimeFrameStop'), 'YYYY-MM-DD');
          eventsBookableTimeFrameStop = Moment(this.usr.get('eventsBookableTimeFrameStop'), 'YYYY-MM-DD');
          minDate = eventsViewableTimeFrameStart < eventsBookableTimeFrameStart ? eventsViewableTimeFrameStart : eventsBookableTimeFrameStart;
          maxDate = eventsViewableTimeFrameStop > eventsBookableTimeFrameStop ? eventsViewableTimeFrameStop : eventsBookableTimeFrameStop;
          options['maxDate'] = new Date(maxDate.year(), maxDate.month() + 1, maxDate.day());
          options['minDate'] = new Date(minDate.year(), minDate.month(), minDate.day());
        }
        $('#id-input-month').mobiscroll().date(options);
        $('#id-input-month').mobiscroll('show');
        return $('.dwwl0').hide();
      }

      __get_reports() {
        var list;
        list = [];
        _.each(_.pluck(_.where(this.usr.get('ProfileProperties').ProfileProperty, {
          "key": "Events:Objects:Himself:sharedMonthlyBasedReports"
        }), 'value'), function(rep) {
          var N, arrName, beautyName, fullName, i, j, ref;
          beautyName = '';
          fullName = rep;
          arrName = rep.split(' ');
          N = arrName.length - 1;
          for (i = j = 1, ref = N; (1 <= ref ? j <= ref : j >= ref); i = 1 <= ref ? ++j : --j) {
            beautyName += arrName[i] + " ";
          }
          return list.push({
            'key': fullName,
            'text': beautyName
          });
        });
        return list;
      }

      __get_pdf_report(report, year, month) {
        var jsonReq, objectID, response, sessionID, xmlReq;
        sessionID = this.usr.get('sessionID');
        objectID = this.usr.get('usersObjectID');
        jsonReq = this.reqMdl.get('JGetPdfReport');
        this.reqMdl.__setNodeValue(jsonReq, 'sessionID', sessionID);
        this.reqMdl.__setNodeValue(jsonReq, 'report', report);
        this.reqMdl.__setNodeValue(jsonReq, 'objectID', objectID);
        this.reqMdl.__setNodeValue(jsonReq, 'year', year);
        this.reqMdl.__setNodeValue(jsonReq, 'month', month);
        xmlReq = this.reqMdl.__getXML(jsonReq);
        $.mobile.loading('show');
        response = this.reqMdl.__send_server_xmlrequest(xmlReq);
        $('#divMonthReportsContent').hide();
        $('#divGeneratingReport').show();
        return response.done(function(data, textStatus, jqXHR) {
          var jsonObj, pdfFile, url;
          jsonObj = data;
          pdfFile = jsonObj.Result.reportFileName;
          url = 'pdf/' + pdfFile;
          $.mobile.loading('hide');
          $('#id-btn-download').attr('href', url);
          $('#id-span-loading').hide();
          return $('.btn-generated').show();
        });
      }

    };
  });

}).call(this);
